#!/bin/bash
#PBS -l nodes=1:ppn=8
##PBS -l mem=100gb
#PBS -l walltime=10:00:00
#PBS -d ./
#PBS -j oe

start=`date +%s`

CPU=$PBS_NP
if [ ! $CPU ]; then
   CPU=2
fi

N=$PBS_ARRAYID
if [ ! $N ]; then
    N=1
fi

#----------------
ctg=`ls *.R1_unmatch_genome.fa | head -n $N | tail -n 1`
prefix=${ctg.R1_unmatch_genome.fa}
program='/public1/home/miyj/sars/fig1/1C/dict-fa-total.py'
program2='/public1/home/miyj/sars/fig1/1C/length_AUCG.py'
genome='/public1//home/miyj/sars/fig4/SARS-COVID.fa'
echo "CPU= $CPU"
echo "FILE= $ctg"
echo "FILE_PREFIX= $prefix"
####bowtie SARS genome obtain 21-23nt bam
#if [ ! -e ${prefix} ]; then
   echo "bowtie prepare"
   source activate
   conda deactivate   
   conda activate smallRNA
   python $program $ctg ${prefix}.fa
   seqkit rename ${prefix}.fa > ${prefix}_total.fa
   bowtie-build $genome genome
   bowtie -f -v 1 -k 10 -t -p $CPU genome ${prefix}_total.fa -S ${prefix}.sam
   rm ${prefix}.fa ${prefix}_total.fa
   echo "bowtie finished"
   samtools view -bS -F 4 ${prefix}.sam >${prefix}_total.bam
   samtools sort -m 500M -@ $CPU -o ${prefix}_total.sort.bam ${prefix}_toal.bam
   samtools index  ${prefix}_total.sort.bam
   rm ${prefix}.sam ${prefix}_total.bam
#   bamCoverage -b ${prefix}.sort.bam -o ${prefix}.sort.bw
   echo "sam2bam finished"
   bamToFastq -i ${prefix}_total.sort.bam -fq ${prefix}_COVID.fq
   bioawk -c fastx '{print ">"$name; print $seq }' ${prefix}_COVID.fq >${prefix}_COVID.fa
   seqkit seq -m 21 -M 23 ${prefix}_COVID.fa > ${prefix}-21_23.fa
   rm ${prefix}_COVID.fa
   bowtie -f -v 1 -k 10 -t -p $CPU genome  ${prefix}-21-23.fa -S ${prefix}-22.sam
   rm ${prefix}-21-23.fa
   samtools view -bhS ${prefix}-22.sam >${prefix}-22.bam
   samtools view -bhS -f 16 ${prefix}-22.sam >${prefix}-22-fu.bam
   samtools view -bhS -F 16 ${prefix}-22.sam >${prefix}-22-zheng.bam
   samtools sort -m 500M -@ $CPU -o ${prefix}-22.sorted.bam ${prefix}-22.bam
   samtools sort -m 500M -@ $CPU -o ${prefix}-22-fu.sorted.bam ${prefix}-22-fu.bam
   samtools sort -m 500M -@ $CPU -o ${prefix}-22-zheng.sorted.bam ${prefix}-22-zheng.bam
   samtools index ${prefix}-22.sort.bam
   samtools index ${prefix}-22-fu.sorted.bam
   samtools index ${prefix}-22-zheng.sorted.bam
   rm ${prefix}-22.sam ${prefix}-22-fu.bam ${prefix}-22-fu.bam ${prefix}-22-zheng.bam
#fi

#----------------
end=`date +%s`
runtime=$((end-start))
h=$(($runtime/3600))
hh=$(($runtime%3600))
m=$(($hh/60))
s=$(($hh%60))

echo "Start= $start"
echo "End= $end"
echo "Run time= $h:$m:$s"
echo "Done!"

